// Copyright (c) 1998-2005 B2C2, Incorporated.  All Rights Reserved.
//
// THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF B2C2, INCORPORATED.
// The copyright notice above does not evidence any
// actual or intended publication of such source code.
//
// This file is proprietary source code of B2C2, Incorporated. and is released pursuant to and
// subject to the restrictions of the non-disclosure agreement and license contract entered
// into by the parties.
//
//
// AVStreamingDlg.cpp : implementation file
//

#include "stdafx.h"
#include "SDKDemo.h"
#include "AVStreamingDlg.h"

#include "IB2C2MPEG2MulticastCtrl.h"
#include ".\avstreamingdlg.h"


// AVStreamingDlg dialog

IMPLEMENT_DYNAMIC(CAVStreamingDlg, CDialog)
CAVStreamingDlg::CAVStreamingDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CAVStreamingDlg::IDD, pParent)
{
}

CAVStreamingDlg::~CAVStreamingDlg()
{
}

void CAVStreamingDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}


BEGIN_MESSAGE_MAP(CAVStreamingDlg, CDialog)
	ON_WM_DESTROY()
END_MESSAGE_MAP()


// AVStreamingDlg message handlers

BOOL CAVStreamingDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	CString cstrTemp;

	cstrTemp.Format( _T("Network Interface: %s\nMulticast Address: %s\nMulticast Port: %d\nPIDs: %d, %d, %d, %d, %d"),
			m_pMulticastInfo->szNetworkAdapter, m_pMulticastInfo->szMulticastAddress, m_pMulticastInfo->wMulticastPort, 
			m_pMulticastInfo->alPIDList[0],m_pMulticastInfo->alPIDList[1],m_pMulticastInfo->alPIDList[2],
			m_pMulticastInfo->alPIDList[3],m_pMulticastInfo->alPIDList[4]);

	
	GetDlgItem(IDC_STATIC_AV_STREAM_DESC)->SetWindowText( cstrTemp );


	m_pB2FilterGraph->GetMulticastControl()->Enable();
	m_pB2FilterGraph->GetMulticastControl()->SetNetworkInterface(m_pMulticastInfo->szNetworkAdapter);
	m_pB2FilterGraph->GetMulticastControl()->StartMulticast(m_pMulticastInfo->szMulticastAddress,
		m_pMulticastInfo->wMulticastPort, m_pMulticastInfo->lPIDCount, m_pMulticastInfo->alPIDList);

	return TRUE;  // return TRUE  unless you set the focus to a control
}


void CAVStreamingDlg::OnCancel()
{
	// TODO: Add your specialized code here and/or call the base class
	CDialog::OnCancel();

	// Destroy this Dialog box
	DestroyWindow();
}

void CAVStreamingDlg::PostNcDestroy()
{
	CDialog::PostNcDestroy();

	// Delete the the class support this dialog.
	delete this;
}

void CAVStreamingDlg::OnDestroy()
{
	CDialog::OnDestroy();

	// TODO: Add your message handler code here

	m_pB2FilterGraph->GetMulticastControl()->StopMulticast(m_pMulticastInfo->szMulticastAddress,
		m_pMulticastInfo->wMulticastPort);

	ZeroMemory( m_pMulticastInfo, sizeof (tMulticastInfo));
}
